/*
 * Decompiled with CFR 0.152.
 */
package me.decce.gnetum;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Map;
import me.decce.gnetum.CacheSetting;
import me.decce.gnetum.ElementType;
import me.decce.gnetum.FpsCounter;
import me.decce.gnetum.FramebufferManager;
import me.decce.gnetum.GnetumConfig;
import me.decce.gnetum.PackedVanillaElements;
import me.decce.gnetum.PassManager;
import me.decce.gnetum.PerformanceAnalyzer;
import me.decce.gnetum.SuggestedPass;
import me.decce.gnetum.UncachedVanillaElements;
import me.decce.gnetum.gui.ConfigScreen;
import me.decce.gnetum.util.AnyBooleanValue;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gnetum")
public final class Gnetum {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "gnetum";
    public static final String HAND_ELEMENT = "gnetum:minecraft_hand";
    public static final FpsCounter FPS_COUNTER = new FpsCounter();
    public static GnetumConfig config;
    public static PassManager passManager;
    public static UncachedVanillaElements uncachedVanillaElements;
    public static String currentElement;
    public static ElementType currentElementType;
    public static long lastSwapNanos;
    public static boolean rendering;
    public static boolean renderingCanceled;
    public static final Lazy<KeyMapping> CONFIG_MAPPING;

    public Gnetum() {
        passManager = new PassManager();
        uncachedVanillaElements = new UncachedVanillaElements();
        GnetumConfig.reload();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(Gnetum::registerBindings);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::onCustomizeF3Text);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerJoin);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, parent) -> new ConfigScreen((Screen)parent)));
    }

    public static CacheSetting getCacheSetting(String vanillaOverlay) {
        if (PackedVanillaElements.isPacked(vanillaOverlay)) {
            vanillaOverlay = PackedVanillaElements.getPacked(vanillaOverlay).getKey();
        }
        if (!Gnetum.config.mapVanillaElements.containsKey(vanillaOverlay)) {
            Gnetum.config.mapVanillaElements.put(vanillaOverlay, new CacheSetting(SuggestedPass.get(vanillaOverlay)));
        }
        return Gnetum.config.mapVanillaElements.get(vanillaOverlay);
    }

    public static CacheSetting getCacheSetting(String moddedOverlay, ElementType type) {
        Map<String, CacheSetting> map;
        if (type == ElementType.VANILLA) {
            return Gnetum.getCacheSetting(moddedOverlay);
        }
        Map<String, CacheSetting> map2 = map = type == ElementType.PRE ? Gnetum.config.mapModdedElementsPre : Gnetum.config.mapModdedElementsPost;
        if (!map.containsKey(moddedOverlay)) {
            map.put(moddedOverlay, new CacheSetting(type == ElementType.PRE ? 1 : Gnetum.config.numberOfPasses));
            config.validate(false);
        }
        return map.get(moddedOverlay);
    }

    public static void disableCachingForCurrentElement() {
        if (currentElement == null || currentElementType == null) {
            return;
        }
        CacheSetting cacheSetting = Gnetum.getCacheSetting(currentElement, currentElementType);
        if (cacheSetting.enabled.get() && cacheSetting.enabled.value == AnyBooleanValue.AUTO) {
            LOGGER.info("Disabling caching for element {}. If the cache setting for this element is set to \"ON\" instead of \"AUTO\" you can ignore this message.", (Object)currentElement);
            cacheSetting.enabled.defaultValue = false;
            FramebufferManager.getInstance().dropCurrentFrame();
        }
    }

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)CONFIG_MAPPING.get());
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (((KeyMapping)CONFIG_MAPPING.get()).m_90859_()) {
                if (Minecraft.m_91087_().f_91080_ instanceof ConfigScreen) continue;
                Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(PerformanceAnalyzer.analyze()));
            }
        }
    }

    public void onCustomizeF3Text(CustomizeGuiOverlayEvent.DebugText event) {
        ArrayList left;
        if (config.isEnabled() && Gnetum.config.showHudFps.get() && Minecraft.m_91087_().f_91066_.f_92063_ && (left = event.getLeft()).size() > 2) {
            event.getLeft().add(2, String.format("HUD: %d fps (nr=%d, cap=%s)", FPS_COUNTER.getFps(), Gnetum.config.numberOfPasses, Gnetum.config.maxFps == 125 ? "unlimited" : Integer.valueOf(Gnetum.config.maxFps)));
        }
    }

    public void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        FPS_COUNTER.reset();
        FramebufferManager.getInstance().reset();
    }

    static {
        CONFIG_MAPPING = Lazy.of(() -> new KeyMapping("gnetum.config.keyMapping", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 269, "key.categories.misc"));
    }
}

